## **Overview of CASB (Cloud Access Service Broker)**

- Acts as an intermediary between:
    - Cloud providers
    - Cloud-based applications
    - Cloud users
- **Primary Functions**:
    - Enforces organizational security policies.
    - Protects data movement through:
        - Restricting access and sharing privileges.
        - Encrypting sensitive data.

---

## **Key Use Cases**

### **1. App Discovery and Control**

- Provides visibility into cloud application activities.
- Allows IT and security teams to:
    - Identify applications in use.
    - Determine which apps are secure for adoption.
    - Block or allow applications based on risk levels and organizational needs.

### **2. Data Loss Prevention (DLP)**

- Inspects outgoing web traffic to prevent sensitive data exposure.
- Supports regulatory compliance by aligning with data security policies.

### **3. Cloud Malware Protection**

- Safeguards against malware in cloud applications.
- Inspects files in supported cloud applications and alerts administrators about threats.

---

## **Core Features of Cisco Umbrella CASB**

### **1. Application Visibility and Control**

- **Functionality**:
    - Detects and monitors cloud applications in use.
    - Groups applications by category and risk profile.
    - Provides tools to allow or block applications based on security policies.
- **App Discovery Report**:
    - Lists applications in use.
    - Helps develop secure cloud adoption strategies.
    - Enables blocking of applications with high risk or inappropriate categories.

### **2. Multimode Cloud Data Loss Prevention (DLP)**

- Protects both **data-in-motion** and **data-at-rest**:
    - **Real Time DLP**:
        - Scans outbound web traffic inline via Umbrella’s Secure Web Gateway (SWG).
        - Focuses on data-in-motion for all cloud destinations.
    - **SaaS API DLP**:
        - Scans data-at-rest in sanctioned cloud services using APIs.
        - Provides near real-time enforcement without requiring internet-bound traffic visibility.
- **Unified Policy Management**:
    - Combines Real Time and SaaS API DLP into one policy.
    - Simplifies administration with unified reporting and event monitoring.
- **On-Demand Discovery Scans**:
    - Identifies files in cloud applications that match selected data classifications.
- **Supported Cloud Applications**:
    - Microsoft OneDrive, SharePoint, Google Drive, Webex App, etc.

### **3. Tenant Controls**

- **Purpose**:
    - Regulates identity access to SaaS applications.
    - Ensures only authorized users or groups can access corporate SaaS instances.
- **Supported Platforms**:
    - Microsoft 365, Google G Suite, Slack, Dropbox.
- **Configuration**:
    - Tenant controls are set up in the Umbrella Tenant Controls page.
    - Can be selected when defining Web policy rulesets.
- **Use Case**:
    - Prevents employees from transferring sensitive data to personal SaaS instances.

### **4. Cloud Malware Protection**

- **Purpose**:
    - Detects and removes malware from cloud-based applications.
    - Protects intellectual property and business operations.
- **Operation**:
    - Uses API-based, out-of-band scanning for sanctioned applications like Microsoft 365, Box, Dropbox, Google Drive, and Webex App.
    - Files are hashed and sent for malware scanning using Cisco Talos threat intelligence.
- **Remediation Actions**:
    - Automatically quarantines malicious files or flags them for further action.
    - Example Actions:
        - Delete infected files from Webex App.
        - Quarantine files in Microsoft 365, Dropbox, Box, and Google Drive.
- **Cloud Malware Report**:
    - Provides a comprehensive view of malware threats across cloud applications.
    - Helps detect compromised accounts and assess threat levels.

---

## **Comprehensive Cloud Security Strategy**

- CASB is a critical component of securing cloud applications and data, but it works best when integrated with:
    - **DNS Layer Security**
    - **Secure Web Gateways (SWG)**
    - **Email Security**
    - **Public Cloud Monitoring Solutions**
    - **Next-Generation Firewall-Integrated Cloud Solutions**
    - **Remote Browser Isolation**